local t = Def.ActorFrame{}

local spacing = 32
local itembaseX = 0
local itembaseY = 32
local delay = 0.25
local labelZoomX = 1.2
local labelZoomY = 1.2

local perfects = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_W1")+
		STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_W2")+
		STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_CheckpointHit");

local greats = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_W3");
local goods = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_W4");
local bads = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_W5");

local misses = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_Miss")+
		STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores("TapNoteScore_CheckpointMiss");

local combo = 	STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):MaxCombo();

local score = 	scorecap(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetScore());

local dancepoints;

if string.find(PREFSMAN:GetPreference("VideoRenderers"), "d3d,") then
	dancepoints = math.floor(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPercentDancePoints()*100)
else
	dancepoints = (math.floor((STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPercentDancePoints())*1000000))/10000
end


local percent = dancepoints.."%";

local digits = string.len(math.max(perfects,greats,goods,bads,misses,combo));
if digits < 3 then digits = 3 end;
--local grade = ToEnumShortString(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade());
	
local grade;

if STATSMAN:GetCurStageStats():AllFailed() then
	grade = "Failed";
else 
	if dancepoints >= 50 then
		grade = "Tier06";
		if dancepoints >= 60 then
			grade = "Tier05";
			if dancepoints >= 70 then
				grade = "Tier04";
				if dancepoints >= 80 then
					grade = "Tier03";
					if misses==0 then
						grade = "Tier02";
						if dancepoints >= 99 then
							grade = "Tier01";
							if dancepoints == 100 then
								grade = "Tier00";
							end
						end
					end
				end	
			end
		end
	else 
		grade = "Tier07";
	end
end

--GRADE
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,center;zoomto,256,52;fadeleft,0.5;faderight,0.5;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX-220;y,itembaseY+(spacing*4.25));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1;shadowlength,0.8;diffuse,0,.8,1,1;diffusetopedge,0,1,1,1;diffusebottomedge,0,.5,1,1);
	OnCommand=cmd(x,itembaseX-220;y,itembaseY+(spacing*4);diffusealpha,0;decelerate,0.3;diffusealpha,1;playcommand,"SetText");
	Text="GRADE";
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1;diffuse,0,.8,1,1;diffusetopedge,0,1,1,1;diffusebottomedge,0,.5,1,1;shadowlength,0.8;maxwidth,192);
	OnCommand=cmd(x,itembaseX-220;y,itembaseY+(spacing*4.75);diffusealpha,0;sleep,1+delay*10;decelerate,0.3;diffusealpha,1);
	Text=percent;
}
t[#t+1] = LoadActor(THEME:GetPathG("","GradeDisplayEval/"..grade))..{
	InitCommand=cmd(horizalign,left;skewx,-0.1;x,itembaseX-188;y,itembaseY+(spacing*4.50));
	OnCommand=cmd(diffusealpha,0;sleep,1+delay*15;decelerate,0.145;diffusealpha,1);
}


--PERFECTS
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4-(spacing*3));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,96);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY-(spacing*3);diffusealpha,0;sleep,1+delay;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(perfects); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(perfects))..perfects;
}


--GREATS
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4-(spacing*2));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,96);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY-(spacing*2);diffusealpha,0;sleep,1+delay*2;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(greats); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(greats))..greats;
}


--GOODS
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4-(spacing*1));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,96);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY-(spacing*1);diffusealpha,0;sleep,1+delay*3;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(goods); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(goods))..goods;
}


--BADS
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4);
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,96);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY;diffusealpha,0;sleep,1+delay*4;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(bads); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(bads))..bads;
}


--MISS
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4+(spacing*1));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,96);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY+(spacing*1);diffusealpha,0;sleep,1+delay*5;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(misses); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(misses))..misses;
}


--COMBO
t[#t+1] = Def.Quad{
	InitCommand=cmd(horizalign,right;zoomto,240,26;fadeleft,1;faderight,0.1;diffuse,0,0,0,1;);
	OnCommand=cmd(x,itembaseX;y,itembaseY-4+(spacing*2));
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(horizalign,right;zoom,1.2;diffuse,.8,.8,.8,1;diffusetopedge,1,1,1,1;diffusebottomedge,0.5,.5,0.5,1;shadowlength,0.8;maxwidth,90);
	OnCommand=cmd(x,itembaseX-96;y,itembaseY+(spacing*2);diffusealpha,0;sleep,1+delay*6;decelerate,0.3;diffusealpha,1;playcommand,"Cap");
	CapCommand=function(self)
			local attr = {
				Length = digits-string.len(combo); 
				Diffuse = color("#FFFFFFFF"); 
			};
		self:AddAttribute(0,attr);
	end;
	Text=string.rep("0",digits-string.len(combo))..combo;
}

return t